#!/bin/sh

printf "\n\n\n\n**** RUNNING build.sh ********************\n\n"

# Set DTR for Docker - Perform against ALL Dockerfiles in your project
/usr/bin/perl -pe "s|%%DTR_URL%%|$DTR_URL|" nextgen/Dockerfile-template | /usr/bin/perl -pe "s|%%DTR_ORG%%|$DTR_ORG|" > nextgen/Dockerfile || { echo "FATAL: Could not set DTR PREFIX or ORG"; exit 1; }

# Dependency Check
printf "\n\n**** Mandatory: Dependency Checks ********************\n"

npm config set registry http://registry.npmjs.org/
npm config set strict-ssl false

#npm config set ca null
export GIT_SSL_NO_VERIFY=true
export NODE_TLS_REJECT_UNAUTHORIZED=0

npm install || { echo "FATAL: Failed on 'npm install'"; exit 1; }
gem install bundler
bundle install || { echo "FATAL: Failed on 'bundle install'"; exit 1; }

# Grunt build/test
printf "\n\n**** Grunt Build (includes unit testing) ********************\n"
grunt build:dist || { echo "FATAL: Failed on 'grunt build'"; exit 1; }

# Generate docker-compose files
source ./nextgen/app.env
./nextgen/generate-docker-compose.sh
./nextgen/generate-docker-compose.sh "-beta"

# Build Artifact Production
printf "\n\n**** Produce Build Artifacts ********************\n"

tar -zcvf $APP_NAME.BUILD-$BUILD_NUMBER.tar.gz dist nextgen docker-compose.yml || { echo "FATAL: Failed on 'Artifact tar'"; exit 1; }

printf "\n\n\n\n**** COMPLETED build.sh ********************\n\n"
